<?php 
include_once "../view/partials/template/message.php";
include_once "../view/partials/banner/bannerHome.php";
include_once "../view/partials/search/ticketSearch.php"; 
?>
<!-- ==========Movie-Main-Section========== -->
<section class="movie-section padding-top padding-bottom bg-two">
    <div class="container">
        <div class="row flex-wrap-reverse justify-content-center">

            <?php include_once "../view/partials/template/promoSideBar.php"; ?>

            <div class="col-lg-9">
                <div class="article-section padding-bottom">
                    <div class="section-header-1">
                        <h2 class="">Eventos</h2>
                        <a class="view-all" href="<?= getUrl("events","Events","eventsList"); ?>">Ver Todo</a>
                    </div>
                    <div class="row mb-30-none justify-content-center">

                        <?php 
                        foreach ($events as $ev) {
                        ?>
                        <div class="col-sm-6 col-lg-4">
                            <div class="event-grid">
                                <div class="movie-thumb c-thumb">
                                    <a href="<?= getUrl("events","Events","eventDetails", array('idE'=>$ev['evenid'])); ?>">
                                        <img src="<?= $ev['evenimg1']; ?>" alt="event">
                                    </a>
                                    <div class="event-date">
                                        <h6 class="date-title"><?= strftime('%d', strtotime($ev['evenfech'])); ?></h6>
                                        <span><?= strftime('%b', strtotime($ev['evenfech'])); ?></span>
                                    </div>
                                </div>
                                <div class="movie-content bg-one" style="min-height: 173px;">
                                    <h5 class="title m-0">
                                        <a href="<?= getUrl("events","Events","eventDetails", array('idE'=>$ev['evenid'])); ?>"><?= $ev['evennomb']; ?></a>
                                    </h5>
                                    <div class="movie-rating-percent">
                                        <span><?= $ev['ciudad']." - ".strftime('%d %b %Y', strtotime($ev['evenfech'])); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php
                        }
                        ?>
                    </div>
                </div>
                
                <?php include_once "../view/partials/template/press.php"; ?>

            </div>
        </div>
    </div>
</section>
<!-- ==========Movie-Main-Section========== -->