<?php
include_once "../view/partials/template/message.php";
include_once "../view/partials/banner/bannerCheckout.php";
?>
<!-- ==========Page-Title========== -->
<section class="page-title bg-one">
    <div class="container">
        <div class="page-title-area">
            <div class="item md-order-1">
                <a href="<?= getUrl("events", "Events", "eventDetails", array("idE" => $idE)); ?>" class="custom-button back-button">
                    <i class="flaticon-double-right-arrows-angles"></i>Regresar
                </a>
            </div>
            <div class="item date-item">
                <h5 class="title"><?= strftime('%A, %b %d %Y', strtotime($e['evenfech'])); ?></h5>
            </div>
            <div class="item">
                <p>Hora del evento</p>
                <p class="title"><?= $e['evenhora'] ?></p>
            </div>
        </div>
    </div>
</section>
<!-- ==========Page-Title========== -->

<!-- ==========Event-Section========== -->
<div class="event-facility padding-bottom padding-top">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-sm-12">

                <div class="checkout-widget checkout-contact">
                    <form method="POST" id="checkoutForm" action="<?= getUrl("events", "Events", "eventTicketReserve") ?>">

                        <input type="hidden" name="idE" id="idEvM" value="<?= $idE; ?>">
                        <input type="hidden" name="nombreE" id="nombreE" value="<?= $e['evennomb']; ?>">

                        <h5 class="title">Recuerda que para asistir a este evento debes tener en cuenta:</h5>
                        <p class="sub-title"><?= $e['evenobse']; ?></p>
                        <div class="row justify-content-center ticket--area ">

                            <?php
                            if (isset($goc)) {
                            ?>
                                <div class="col-sm-8 col-md-6 col-lg-5 col-xl-4">
                                    <div class="ticket-item">
                                        <div class="ticket-thumb">
                                            <img src="images/event/ticket/ticket01.png" alt="event">
                                        </div>
                                        <div class="ticket-content">
                                            <span class="ticket-title"><?= $goc['locanomb']; ?></span>
                                            <h3 class="amount">$<?= number_format($goc['locavabo'], 0, ",", ".") . "<sup>" . $goc['cavaaux2']; ?></sup></h3>
                                        </div>
                                    </div>
                                </div>

                                <?php

                            } else {

                                if ($locations) {

                                    foreach ($locations as $loc) {
                                ?>
                                        <div class="col-sm-8 col-md-6 col-lg-5 col-xl-4">
                                            <div class="ticket-item">
                                                <div class="ticket-thumb">
                                                    <img src="images/event/ticket/ticket01.png" alt="event">
                                                </div>
                                                <div class="ticket-content">
                                                    <span class="ticket-title"><?= $loc['locanomb']; ?></span>
                                                    <h3 class="amount">$<?= number_format($loc['locavabo'], 0, ",", ".") . "<sup>" . $loc['cavaaux2']; ?></sup></h3>
                                                    <div>
                                                        <input type="radio" name="locId" class="t-button" value="<?= $loc['locaid']; ?>" data-url="<?= getUrl("events", "Events", "getEventData", array('locaid' => $loc['locaid']), "ajax"); ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php
                                    }
                                } else { ?>

                                    <div class="col-sm-8 col-md-6 col-lg-5 col-xl-4">
                                        <div class="ticket-item">
                                            <div class="ticket-thumb">
                                                <img src="images/event/ticket/ticket01.png" alt="event">
                                            </div>
                                            <div class="ticket-content">
                                                <span class="ticket-title">¡Oops!
                                                    <h3 class="amount">AGOTADO</h3>
                                                    <div>
                                                        <p class="sub-title">Parece que los tickets para este evento est&aacute;n agotados</p>
                                                    </div>
                                            </div>
                                        </div>
                                    </div>

                            <?php }
                            }
                            ?>
                        </div>

                        <?php if (isset($goc)) { ?>

                            <div class="row" id="qtyblock">
                                <p class="sub-title">¡Atenci&oacute;n! Ya existe una orden de compra pendiente, puede añadir más boletos a la misma o <a class="mx-0 text-white" href="<?= getUrl("shoppingCart", "shoppingCart", "showShoppingCart"); ?>"><b>ir al carrito de compras</b></a> para completarla.</p>
                            </div>

                        <?php } else { ?>

                            <div class="row mb-30-none" id="qtyblock" style="display:none;">
                                <div class="col-5">
                                    <div class="cart-button event-cart">
                                        <span class="d-inline-block">Cantidad: </span>
                                        <div class="cart-plus-minus" id="qtySection">
                                            <div class="dec qtybutton">-</div>

                                            <input type="hidden" name="qtybutton" id="qtyvalue" value="1" data-url="<?= getUrl("events", "Events", "checkEventTicket", false, "ajax"); ?>" data-tag="#cantbol">

                                            <input class="cart-plus-minus-box" id="qtybutton" type="text" value="1" readonly>

                                            <div class="inc qtybutton">+</div>
                                        </div>
                                        <div id="qtyAlert"></div>
                                    </div>
                                </div>
                                <div class="col-7">
                                    <div class="checkout-contact-form mb-0 float-right">

                                        <?php if ($e['evencupo'] == 1) { ?>

                                            <div class="form-group">
                                                <input type="text" name="codProm" id="codProm" placeholder="C&oacute;digo promocional">
                                            </div>

                                        <?php } ?>

                                        <div class="form-group">
                                            <input type="submit" value="Confirmar" class="custom-button">
                                        </div>
                                    </div>
                                </div>
                            </div>

                        <?php } ?>

                    </form>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="booking-summery bg-one">
                    <h4 class="title">Informaci&oacute;n</h4>
                    <ul>
                        <li>
                            <h6 class="subtitle">Localidad</h6>
                            <span class="info" id="locanomb"><?= $goc['locanomb'];  ?></span>
                        </li>
                        <li>
                            <h6 class="subtitle"><span>Valor por boleto</span></h6>
                            <span class="info" id="valbol"><?= number_format($goc['locavabo'], 0, ",", "."); ?></span>
                        </li>
                        <li>
                            <h6 class="subtitle mb-0">Cover service</h6>
                            <span class="info" id="valcoser"><?= number_format($valorTotalCS, 0, ",", "."); ?></span>
                        </li>
                        <li>
                            <h6 class="subtitle mb-0">Descuento</h6><!-- 04 Feb 2023 JFMI -->
                            <span class="info" id="qty"><?= number_format($valorDesc, 0, ",", "."); ?></span>
                        </li>
                        <li>
                            <h6 class="subtitle mb-0">Cantidad</h6>
                            <span class="info" id="qty"><?= number_format($occantidad, 0, ",", "."); ?></span>
                        </li>

                    </ul>
                    <ul class="side-shape">
                        <li>
                            <h6 class="subtitle"><span>Total</span><span id="valtotal"><?= number_format($valorAPagar, 0, ",", "."); ?></span></h6>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- ==========Event-Section========== -->