<?php 
	include_once "../model/Datos.php";
	class TicketsModel extends Datos{

		#Obtiene los eventos en los que el usuario ha adquirido tickets
		public function getUserEvents($userId) {

			$query = $this->read("DISTINCT e.evenid, e.evennomb, e.evenobse, e.evenimg2, e.evenfech, dg.digedesc AS ciudad", "blockchain bc, localidades loc, eventos e, divigeo dg", "bc.usuarioId = $userId AND bc.idusuarioValor = 0  AND bc.localidadId = loc.locaid AND loc.locaevid = e.evenid AND dg.digeid = e.evenciud AND CONCAT(e.evenfech, ' ', e.evenhora) > CURRENT_TIMESTAMP", "ORDER BY bc.fechaevento");

			return $query;
		}

		public function getUsedEvents($userId) {

			$query = $this->read("DISTINCT e.evenid, e.evennomb, e.evenobse, e.evenimg2, e.evenfech, dg.digedesc AS ciudad", "blockchain bc, localidades loc, eventos e, divigeo dg", "bc.usuarioId = $userId AND bc.idusuarioValor = 0  AND bc.leido = 'SI' AND bc.localidadId = loc.locaid AND loc.locaevid = e.evenid AND dg.digeid = e.evenciud", "ORDER BY bc.fechaevento");

			return $query;
		}

		public function getTransferedEvents($userId) {

			$query = $this->read("DISTINCT e.evenid, e.evennomb, e.evenobse, e.evenimg2, e.evenfech, dg.digedesc AS ciudad", "blockchain bc, localidades loc, eventos e, divigeo dg", "bc.usuarioId = $userId AND bc.idusuarioValor <> 0 AND bc.localidadId = loc.locaid AND loc.locaevid = e.evenid AND dg.digeid = e.evenciud", "ORDER BY bc.fechaevento");

			return $query;
		}

		#Obtiene los tickets comprados que aun no han sido usados ni transferidos
		public function getUserTickets($userId) {

			$query = $this->read("bc.id, bc.indexChain, bc.numboleta, bc.leido, bc.idusuariovalor, loc.locanomb, e.evenid", "blockchain bc, localidades loc, eventos e, divigeo dg", "bc.usuarioId = $userId AND bc.leido = 'NO' AND bc.idusuarioValor = 0 AND bc.localidadId = loc.locaid AND loc.locaevid = e.evenid AND dg.digeid = e.evenciud", "ORDER BY bc.fechaevento");

			return $query;
		}

		#Obtiene los tickets usados en eventos por el usuario
		public function getUsedTickets($userId) {

			$query = $this->read("bc.id, bc.indexChain, bc.numboleta, bc.leido, bc.idusuariovalor, loc.locanomb, e.evenid", "blockchain bc, localidades loc, eventos e, divigeo dg", "bc.usuarioId = $userId AND bc.localidadId = loc.locaid AND bc.leido = 'SI' AND bc.idusuarioValor = 0 AND loc.locaevid = e.evenid AND dg.digeid = e.evenciud", "ORDER BY bc.fechaevento");

			return $query;
		}

		#Obtiene los tickets usados en eventos por el usuario
		public function getTransferedTickets($userId) {

			$query = $this->read("bc.id, bc.indexChain, bc.numboleta, bc.leido, bc.idusuariovalor, loc.locanomb, e.evenid, CONCAT(u.usuanomb,' ',u.usuaapel) as usuatrans", "blockchain bc, localidades loc, eventos e, divigeo dg, usuarios u", "bc.usuarioId = $userId AND  bc.idusuariovalor <> 0 AND bc.localidadId = loc.locaid AND loc.locaevid = e.evenid AND dg.digeid = e.evenciud AND bc.idusuarioValor = u.usuaid", "ORDER BY bc.fechaevento");

			return $query;
		}
		
	}
?>