<?php
include_once "../model/Datos.php";
class EventModel extends Datos
{

	# Consulta y lista eventos por categoria o general
	public function getEvents($idCategory = false, $event = false, $city = false)
	{

		$cat = "";
		$ev = "";
		$cty = "";
		if ($idCategory) {

			$cat = "e.evencate = $idCategory AND";
		} else {

			if ($event && $city) {

				$ev = "e.evennomb LIKE '%" . $event . "%'";
				$cty = "AND e.evenciud = $city AND";
			}
		}

		$query = $this->read("e.evenid, e.evenciud, e.evenclid, e.evennomb, e.evenfech, e.evenimg1, dg.digedesc AS ciudad, c.clienomb", "eventos e, divigeo dg, clientes c", "$cat $ev $cty e.evenciud = dg.digeid AND c.clieid = e.evenclid  AND CONCAT(e.evenfech, ' ', e.evenhora) > CURRENT_TIMESTAMP AND e.evenesta = 19");

		return $query;
	}

	# Captura la categoria del evento o lista de eventos
	public function getCategories()
	{

		$query = $this->read("cv.cavaid, cv.cavadesc", "catavalo cv", "cv.cavacaid = 7 AND cv.cavaesta = 1", "ORDER BY cv.cavadesc ASC");

		return $query;
	}

	# Captura las ciudades para la visualizacion en ticket search
	public function getCities()
	{

		$query = $this->read("dg.digeid, dg.digedesc", "divigeo dg", "dg.digetipo = 34", "ORDER BY dg.digeid ASC");
		// AND dg.digerefe = $_SESSION['usuapais']

		return $query;
	}

	# Captura las fechas de eventos proximos para la visualizacion en ticket search
	public function getDates()
	{

		$query = $this->read("DISTINCT e.evenfech", "eventos e", "CONCAT(e.evenfech, ' ', e.evenhora) > CURRENT_TIMESTAMP AND e.evenesta = 19", "ORDER BY e.evenfech ASC");

		return $query;
	}

	# Obtiene los detalles de un evento especifico
	public function getEventDetails($idEvento)
	{

		$query = $this->read("e.evenid, e.evenciud, e.evencate, e.evenclid, e.evennomb, e.evencome, e.evenfech, e.evenhora, e.evencabo, e.evenubic, e.evenimg2, e.evenviid, dg.digedesc AS ciudad, dg2.digedesc AS pais, c.cavadesc AS categoria", "eventos e, divigeo dg, divigeo dg2, catavalo c", "e.evenid = $idEvento AND dg.digeid = e.evenciud AND dg.digerefe = dg2.digeid AND e.evencate = c.cavaid  AND CONCAT(e.evenfech, ' ', e.evenhora) > CURRENT_TIMESTAMP AND e.evenesta = 19");

		return $query[0];
	}

	# captura la data del evento para el checkout
	public function getEventCheckout($idE)
	{

		$query = $this->read("e.evenid, e.evencate, e.evenciud, e.evenclid, e.evennomb, e.evenobse, e.evenfech, e.evenhora,	e.evenubic, e.evenimg2, e.evencupo, cv.cavaaux1, dg.digedesc AS ciudad, c.cavadesc AS categoria", "eventos e, divigeo dg, catavalo c, catavalo cv", "e.evenid = $idE AND dg.digeid = e.evenciud AND e.evencate = c.cavaid AND e.evenimpu = cv.cavaid AND e.evenesta = 19");

		return $query[0];
	}

	# consulta ordenes de compra pendientes
	public function getOrdenCompraEvento($idE)
	{

		$query = $this->read("oc.orcoid, oc.orcoloid,oc.orcovalo, oc.orcocabo, loc.locanomb, loc.locavabo, loc.locapoco, cv.cavaaux2", "ordecompra oc,localidades loc, catavalo cv", "oc.orcousid = " . $_SESSION['id'] . " AND loc.locaevid = $idE AND oc.orcoloid = loc.locaid AND loc.locatimo = cv.cavaid AND oc.orcoesta = 38");

		if ($query) {

			return $query[0];
		}
	}

	# Consulta las localidades para el evento master
	public function getEventLoc($idE)
	{
		//AND loc.locabove < loc.locacabo
		$query = $this->read("loc.locaid, loc.locanomb, loc.locavabo, loc.locapoco, e.evenclid, cv.cavaaux1, cv.cavaaux2", "localidades loc, eventos e, catavalo cv", "loc.locaevid = $idE AND loc.locaevid = e.evenid  AND loc.locatimo = cv.cavaid AND loc.locaesta = 35");

		return $query;
	}

	# consulta los campos de la localidad seleccionada para la reserva
	public function getLocData($locId, $idE)
	{

		$query = $this->read("loc.locaid, loc.locapoco, loc.locanomb, loc.locacabo, loc.locabove, loc.locavabo, loc.locaboeq, e.eventipo, e.evencave, e.evencupo, e.eventipo, cv.cavaaux1,e.evenesta", "eventos e, localidades loc, catavalo cv", "loc.locaid = $locId AND e.evenid = $idE AND loc.locaevid = e.evenid AND e.evenimpu = cv.cavaid AND loc.locaesta = 35");

		return $query[0];
	}

	# Obtiene la data del cupon para la localidad seleccionada
	public function getEventCoupon($locId, $codProm)
	{

		$query = $this->read("cup.cupoid, cup.cupodesc,cup.cupotipo", "cupones cup", "cup.cupoloid = $locId AND cup.cupocodi = '$codProm' AND cup.cupoesta = 41 AND cup.cupodisp > cup.cuporedi");

		return $query[0];
	}

	# Captura la data de la orden de compra pendiente 
	# para la validación de nuevos tickets AJAX
	public function ordenCompraAjax($ocid, $locId)
	{

		$query = $this->read("oc.orcoid, oc.orcocabo, loc.locacabo, loc.locabove, loc.locaboeq, ev.evencave", "ordecompra oc, localidades loc, eventos ev", "oc.orcoloid = loc.locaid AND oc.orcousid = " . $_SESSION['id'] . " AND loc.locaid = $locId AND oc.orcoid = $ocid AND loc.locaevid = ev.evenid");

		return $query[0];
	}

	# Consulta la cantidad de boletos seleccionados en localidad AJAX
	public function getTicketAjax($locId)
	{

		$query = $this->read("loc.locaid, loc.locacabo, loc.locabove, loc.locaboeq, ev.evencave", "localidades loc, eventos ev", "loc.locaid = $locId AND loc.locaevid = ev.evenid");

		return $query[0];
	}

	# Consulta la data del evento y muestra en tabla AJAX
	public function getEventDataAjax($locaid)
	{

		$query = $this->read("loc.locaid, loc.locanomb, loc.locavabo, loc.locapoco, cv.cavaaux1", "localidades loc, eventos ev, catavalo cv", "loc.locaid = $locaid AND loc.locaesta = 35 AND loc.locaevid = ev.evenid AND ev.evenimpu = cv.cavaid");

		return $query[0];
	}
	# Consulta cantidad de boletos vendidos por localidad
	public function getTicketsVendidos($locaid)
	{

		$query = $this->read("count(DISTINCT numboleta) as max ", "blockchain", "localidadId = $locaid");

		return $query[0];
	}
}
