<?php 
	include_once "../model/tickets/TicketsModel.php";
	class TicketsController{

		private $obj;
		public function __construct() {

			$this->obj = new TicketsModel();
		}

		public function showTickets() {

            if($_SESSION) {

                $events = $this->obj->getUserEvents($_SESSION['id']);
                
                $tickets = $this->obj->getUserTickets($_SESSION['id']);
    
                include_once "../view/tickets/showTickets.php";
            } else {

                redirect(getUrl("home", "Home", "home"));
            }

		}

        public function showUsedTickets() {

            if($_SESSION){

                $events = $this->obj->getUsedEvents($_SESSION['id']);
                
                $tickets = $this->obj->getUsedTickets($_SESSION['id']);
    
                include_once "../view/tickets/showUsedTickets.php";
            } else {

                redirect(getUrl("home", "Home", "home"));
            }

        }

        public function showTransferedTickets() {

            if($_SESSION){

                $events = $this->obj->getTransferedEvents($_SESSION['id']);
                
                $tickets = $this->obj->getTransferedTickets($_SESSION['id']);

                include_once "../view/tickets/showTransferedTickets.php";
            } else {

                redirect(getUrl("home", "Home", "home"));
            }
        }

        public function transferTickets() {

            if($_POST['transfernumber'] != $_SESSION['celular']) {

                $ticketnum = $_POST['ticketnum'];
                $transfernumber = $_POST['transfernumber'];
    
                $dataTransfer = [
                    "action"=>"transferirboleto",
                    "ticketid"=> $ticketnum,             
                    "usuarioid"=> $_SESSION['id'],
                    "walletcelular" => $transfernumber
                ];  
    
                # Instancio la clase para el pase de los boletos a la wallet
                include_once "../controller/webApi/WebApiController.php";
                                
                $webApi = new webApiController();
    
                $res = $webApi->boletoWebApiController($dataTransfer);
    
                if($res['status'] == 1 && $res['response'] == 1) {
                        
                    $_SESSION['message'] = 1;
                    $_SESSION['message_icon'] = "success";
                    $_SESSION['message_text'] = "¡Boleto transferido con &eacute;xito!";
                    
                } elseif($res['response'] == 2){
                    
                    $_SESSION['message'] = 1;
                    $_SESSION['message_icon'] = "error";
                    $_SESSION['message_text'] = "¡Error! El n&uacute;mero celular al que intenta transferir no existe, por favor verif&iacute;calo.";
                    
                } elseif($res['response'] == 7) {
    
                    $_SESSION['message'] = 1;
                    $_SESSION['message_icon'] = "warning";
                    $_SESSION['message_text'] = "¡Error! El boleto ya excedi&oacute; el n&uacute;mero m&aacute;ximo de transferencias.";
    
                } else {
    
                    $_SESSION['message'] = 1;
                    $_SESSION['message_icon'] = "error";
                    $_SESSION['message_text'] = "¡Error! Ocurri&oacute; un error inesperado, por favor intentelo nuevamente ".$res['status']."-".$res['response']."-".$res['data'];
                }
            } else {

                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "error";
                $_SESSION['message_text'] = "¡Error! No puedes transferir boletos a tu propio n&uacute;mero";
            }
            redirect(getUrl("tickets", "Tickets", "showTickets"));
        }
	}
?>