<?php

include_once "../model/shoppingCart/ShoppingCartModel.php";
Class ShoppingCartController {

	private $obj;
	#instancia class model para conexion a BD
	public function __construct() {

		$this->obj = new ShoppingCartModel();
	}

	# Genera la vista del carrito de compras con las ordenes del cliente
	public function showShoppingCart() {

		#consulta las ordenes de compra pendientes del cliente
		if($getItemsCart = $this->obj->getOrdenesCompra()) {
            
            # instancio la clase de mercado pago
            require_once "../controller/mercadoPago/MercadoPagoController.php";

            $mPago = new MercadoPagoController();
            
			include_once "../view/shoppingCart/shoppingCart.php";

		} else {

            $_SESSION['message'] = 1;
            $_SESSION['message_icon'] = "warning";
            $_SESSION['message_text'] = "¡Oops! Parece que a&uacute;n no tienes nada en tu carrito de compras.";
			redirect(getUrl("events", "Events", "eventsList"));

		}
	}

    # Funcion que captura la respuesta del servicio de pagos Wompi
    public function getWompiPayResponse() {

        # Creacion de archivo para log de data retornada
        $log = fopen("logPagos.txt", 'a') or die ("Error creando archivo");
        fwrite($log, "\n".date("d/m/Y H:i:s").json_encode($_REQUEST)) or die("Error escribiendo en el archivo");
        fclose($log);

        if(isset($_GET['tokenCompra'])) {

            # Defino url para consumo de cURL
            $url = "https://production.wompi.co/v1/transactions/";
            $transac_id = $_GET['id'];
            
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url.$transac_id,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "cache-control: no-cache"
                ),
            ));
            
            # Valida si se ejecuta el servicio
            if($response = curl_exec($curl)){
                
                # deserializo el arreglo json del api wompi
                $response = json_decode($response, true);
                
                $status = $response['data']['status'];
                $reference = $_GET['tokenCompra'];
                $transac_id = $response['data']['id'];
                $paymentMethod = $response['data']['payment_method_type'];

                # Captura ordenes de compra
                if($dataOrden = $this->obj->getOrdenCompra($reference)){
                    
                    # Si el estado es aprobado valido que el estado sea pendiente
                    if($status == "APPROVED") {
                        
                            $dataCompra = [
                                "action" => "pagarboletos",
                                "token" => $dataOrden['orcotoke'],
                                "metodo" => 60
                            ];
                            
                            # Instancio la clase para el pase de los boletos a la wallet.
                            include_once "../controller/webApi/WebApiController.php";
                            
                            $webApi = new webApiController();
                            
                            # Consumo la función y capturo aspoteriori la respuesta.
                            $res = $webApi->boletoWebApiController($dataCompra);
                            $logFile = fopen("apilog.txt", 'a') or die("Error creando archivo");
                            fwrite($logFile, "\n".date("d/m/Y H:i:s")."--> Wompi --> ".json_encode($dataCompra)) or die("Error escribiendo en el archivo");fclose($logFile);
                
                            
                            if($res['response'] == 1) {
                                
                                $_SESSION['message'] = 1;
                                $_SESSION['message_icon'] = "success";
                                $_SESSION['message_text'] = "¡Los boletos han sido transferidos a tu wallet!";

                            } elseif($res['response'] == 0) {
        
                                $_SESSION['message'] = 1;
                                $_SESSION['message_icon'] = "error";
                                $_SESSION['message_text'] = "¡Error al liberar boletos! Intentalo nuevamente Response: ".$res['response']."";

                            } else {
        
                                $_SESSION['message'] = 1;
                                $_SESSION['message_icon'] = "error";
                                $_SESSION['message_text'] = "¡Lo sentimos! Hemos tenido un error al realizar tu reserva. <br> Response: ".$res['response']." / Response: ".$res['data']."";      
                            }
                    } else {
                        
                        $_SESSION['message'] = 1;
                        $_SESSION['message_icon'] = "error";
                        $_SESSION['message_text'] = "¡Error al procesar pago, por favor int&eacute;ntalo de nuevo: ".$status."";
                    }
                
                }

                curl_close($curl);

                # Genero el registro del log del proceso 
                $logArray = ['orcoid'=>$dataOrden['orcoid'], 'orcotoke'=>$dataOrden['orcotoke'],'paymentMethod'=> $paymentMethod, 'transac_id'=>$transac_id,'status'=>$status];
                
                $this->obj->storePaylogs($logArray);

                if($status == "APPROVED") {

                    redirect(getUrl("events", "Events", "eventsList"));
                } else {

                    redirect(getUrl("shoppingCart", "ShoppingCart", "showShoppingCart"));
                }
                
            } else {
                
                $err = curl_error($curl); 
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "error";
                $_SESSION['message_text'] = "¡Error! Tuvimos problemas para consultar el estado de tu orden, error: ".$err;
                redirect(getUrl("shoppingCart", "ShoppingCart", "showShoppingCart"));
            }
            
        }
    }

    # Funcion que captura la respuesta del servicio de pagos Nequi
    public function getNequiPayResponse() {

        # Creacion de archivo para log de data retornada
        $log = fopen("logPagos.txt", 'a') or die ("Error creando archivo");
        fwrite($log, "\n".date("d/m/Y H:i:s").json_encode($_REQUEST)) or die("Error escribiendo en el archivo");
        fclose($log);

        if(isset($_GET['tokenCompra'])) {
                
                $status = "APPROVED";
                $reference = $_GET['tokenCompra'];
                $transac_id = $_GET['TransactionId'];;
                $paymentMethod = "Nequi";

                # Captura ordenes de compra
                if($dataOrden = $this->obj->getOrdenCompra($reference))
                {
                    
                    # Si el estado es aprobado valido que el estado sea pendiente
                    if($status == "APPROVED") {
                        
                            $dataCompra = [
                                "action" => "pagarboletos",
                                "token" => $dataOrden['orcotoke'],
                                "metodo" => 96
                            ];
                            
                            # Instancio la clase para el pase de los boletos a la wallet.
                            include_once "../controller/webApi/WebApiController.php";
                            
                            $webApi = new webApiController();
                            
                            # Consumo la función y capturo aspoteriori la respuesta.
                            $res = $webApi->boletoWebApiController($dataCompra);
                            $logFile = fopen("apilog.txt", 'a') or die("Error creando archivo");
                            fwrite($logFile, "\n".date("d/m/Y H:i:s")."--> Wompi --> ".json_encode($dataCompra)) or die("Error escribiendo en el archivo");fclose($logFile);
                
                            
                            if($res['response'] == 1) {
                                
                                $_SESSION['message'] = 1;
                                $_SESSION['message_icon'] = "success";
                                $_SESSION['message_text'] = "¡Los boletos han sido transferidos a tu wallet!";

                            } elseif($res['response'] == 0) {
        
                                $_SESSION['message'] = 1;
                                $_SESSION['message_icon'] = "error";
                                $_SESSION['message_text'] = "¡Error al liberar boletos! Intentalo nuevamente Response: ".$res['response']."";

                            } else {
        
                                $_SESSION['message'] = 1;
                                $_SESSION['message_icon'] = "error";
                                $_SESSION['message_text'] = "¡Lo sentimos! Hemos tenido un error al realizar tu reserva. <br> Response: ".$res['response']." / Response: ".$res['data']."";      
                            }
                    } else {
                        
                        $_SESSION['message'] = 1;
                        $_SESSION['message_icon'] = "error";
                        $_SESSION['message_text'] = "¡Error al procesar pago, por favor int&eacute;ntalo de nuevo: ".$status."";
                    }
                
                }

                

                # Genero el registro del log del proceso 
                $logArray = ['orcoid'=>$dataOrden['orcoid'], 'orcotoke'=>$dataOrden['orcotoke'],'paymentMethod'=> $paymentMethod, 'transac_id'=>$transac_id,'status'=>$status];
                
                $this->obj->storePaylogs($logArray);

                if($status == "APPROVED") {

                    redirect(getUrl("events", "Events", "eventsList"));
                } else {

                    redirect(getUrl("shoppingCart", "ShoppingCart", "showShoppingCart"));
                }
                

            
        }
    }    

    #Consulta estado de pago en caso de pago parcial o completo por partes
    public function consultaEstadoPagoMP() {	
        
        $id = $_GET['id'];
        $topic = $_GET['topic'];
        $token = $_GET['token'];

		include_once "../controllers/mercadoPago/MercadoPagoController.php";

        $MP = new MercadoPagoController();

        # Consulta estado del pago actual.
		$result = $MP->consultaMercadoPagoEstadoPago($id,$topic);

		if ($result != 3 )//pagada
		{	 

            $dataCompra = [
                "action" => "pagarboletos",
                "token" => $token,
                "metodo" => 59
            ];

		    include_once "../controller/webApi/WebApiController.php";

            $webApi = new webApiController();

            # Consumo la función y capturo aspoteriori la respuesta.
            $res = $webApi->boletoWebApiController($dataCompra);
            $logFile = fopen("apilog.txt", 'a') or die("Error creando archivo");
            fwrite($logFile, "\n".date("d/m/Y H:i:s")."--> Mercado --> ".json_encode($dataCompra)) or die("Error escribiendo en el archivo");fclose($logFile);

	        if($res['response'] == 1) {
                    
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "success";
                $_SESSION['message_text'] = "¡Los boletos han sido transferidos a tu wallet!";
                
            } elseif($res['response'] == 0) {
                
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "error";
                $_SESSION['message_text'] = "¡Error al liberar boletos! Intentalo nuevamente Response: ".$res['status']."";
                
            } else {
                
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "error";
                $_SESSION['message_text'] = "¡Lo sentimos! Hemos tenido un error al realizar tu reserva. <br> Status: ".$res['status']." / Response: ".$res['response']."";
                
            }
            
		} else {

            $_SESSION['message'] = 1;
            $_SESSION['message_icon'] = "info";
            $_SESSION['message_text'] = "A&uacute;n tienes pendiente completar tu pago";
        }

        redirect(getUrl("home", "Home", "home"));
	}

    # Funcion que recibe respuesta del servicio de MercadoPago
    public function getMpagoApproved() {

        # Creacion de archivo para log de data retornada
        $log = fopen("logPagos.txt", 'a') or die ("Error creando archivo");
        fwrite($log, "\n".date("d/m/Y H:i:s").json_encode($_REQUEST)) or die("Error escribiendo en el archivo");
        fclose($log);

        $reference = $_GET['ext_ref'];

        # Extrae data de la orden de compra pendiente
        if($dataOrden = $this->obj->getOrdenCompra($reference)) {

            $dataCompra = [
                "action" => "pagarboletos",
                "token" => $dataOrden['orcotoke'],
                "metodo" => 59
            ];

            #Instancia la clase para el consumo del web api blockchain
            include_once "../controller/webApi/WebApiController.php";

            $webApi = new webApiController();
            $logFile = fopen("apilog.txt", 'a') or die("Error creando archivo");
            fwrite($logFile, "\n".date("d/m/Y H:i:s")."--> Mercado --> ".json_encode($dataCompra)) or die("Error escribiendo en el archivo");fclose($logFile);

            $res = $webApi->boletoWebApiController($dataCompra);

            if($res['response'] == 1) {
                
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "success";
                $_SESSION['message_text'] = "¡Los boletos han sido transferidos a tu wallet!";
                
            } elseif($res['response'] == 0) {
                
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "error";
                $_SESSION['message_text'] = "¡Error al liberar boletos! Intentalo nuevamente Response: ".$res['status']."";
                
            } else {
                
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "error";
                $_SESSION['message_text'] = "¡Lo sentimos! Hemos tenido un error al realizar tu reserva. <br> Status: ".$res['status']." / Response: ".$res['response']."";
                
            }
        }

        # Registra el log del procedimiento
        $logArray = ['orcoid'=>$dataOrden['orcoid'], 'orcotoke'=>$dataOrden['orcotoke'],'paymentMethod'=> $_GET['payment_type'], 'transac_id'=>$_GET['payment_id'],'status'=>$_GET['status']];
            
        $this->obj->storePaylogs($logArray);

        redirect(getUrl("events", "Events", "eventsList"));
    }

    # Funcion para capturar los eventos de pago pendiente o errado con Mpago
    public function getMpagoStatus() {

        if($_GET['status'] == "pending") {

            $_SESSION['message'] = 1;
            $_SESSION['message_icon'] = "info";
            $_SESSION['message_text'] = "¡Pago pendiente! En cuanto completes el pago liberaremos los boletos en tu wallet.";

        } else {

            $_SESSION['message'] = 1;
            $_SESSION['message_icon'] = "error";
            $_SESSION['message_text'] = "¡Oops! Parece que ha habido un error, por favor vuelve a intentarlo.";

        }

        $reference = $_GET['external_reference'];

        if($dataOrden = $this->obj->getOrdenCompra($reference)) {    

            $logArray = ['orcoid'=>$dataOrden['orcoid'], 'orcotoke'=>$dataOrden['orcotoke'],'paymentMethod'=> 'MERCADO_PAGO', 'transac_id'=>$_GET['payment_id'],'status'=>$_GET['status']];
                    
            $this->obj->storePaylogs($logArray);

            redirect(getUrl("shoppingCart", "ShoppingCart", "showShoppingCart"));
            
        }
    }

    # Cancela la orden de compra seleccionada por medio de swift alert
    public function cancelaOrdenCompra() {

        $tokenOrden = $_GET['orcotoke'];

        if($dataOrden = $this->obj->getOrdenCompra($tokenOrden)){

            $dataCancela = [
                "action" => "cancelarreserva",
                "token" => $dataOrden['orcotoke']
            ];

            # Instancio la clase para el pase de los boletos a la wallet
            include_once "../controller/webApi/WebApiController.php";
            $logFile = fopen("apilog.txt", 'a') or die("Error creando archivo");
            fwrite($logFile, "\n".date("d/m/Y H:i:s").json_encode($dataCancela)) or die("Error escribiendo en el archivo");fclose($logFile);
                            
            $webApi = new webApiController();
            
            $res = $webApi->boletoWebApiController($dataCancela);
            
            if($res['response'] == 1) {
                    
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "success";
                $_SESSION['message_text'] = "¡Orden cancelada con &eacute;xito!";
                
            } else {
                
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "error";
                $_SESSION['message_text'] = "¡Error! esta orden de compra no está pendiente por pagar";
                
            }

            redirect(getUrl("home", "Home", "home"));
        }
    }

    # Funcion que recibe respuesta del servicio de FreeyPay
    public function getFreepayApproved() {
        $token = $_GET['orcotoke'];
        //$orcoid = $_GET['orcoid'];
        # Extrae data de la orden de compra pendiente  getTickets
        if($dataOrden = $this->obj->getOrdenCompra($token)) {

            $dataCompra = [
                "action" => "pagarboletos",
                "token" => $dataOrden['orcotoke'],
                "metodo" => 74
            ];

            #Instancia la clase para el consumo del web api blockchain
            include_once "../controller/webApi/WebApiController.php";

            $webApi = new webApiController();
            //$logFile = fopen("apilog.txt", 'a') or die("Error creando archivo");
            //fwrite($logFile, "\n".date("d/m/Y H:i:s")."--> Mercado --> ".json_encode($dataCompra)) or die("Error escribiendo en el archivo");fclose($logFile);

            $res = $webApi->boletoWebApiController($dataCompra);

            if($res['response'] == 1) {
                
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "success";
                $_SESSION['message_text'] = "¡Los boletos han sido transferidos a tu wallet!";
                
            } elseif($res['response'] == 0) {
                
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "error";
                $_SESSION['message_text'] = "¡Error al liberar boletos! Intentalo nuevamente Response: ".$res['status']."";
                
            } else {
                
                $_SESSION['message'] = 1;
                $_SESSION['message_icon'] = "error";
                $_SESSION['message_text'] = "¡Lo sentimos! Hemos tenido un error al realizar tu reserva. <br> Status: ".$res['status']." / Response: ".$res['response']."";
                
            }
        }

        # Registra el log del procedimiento
        $logArray = ['orcoid'=>$dataOrden['orcoid'], 'orcotoke'=>$token,'paymentMethod'=> 'FREEPAY', 'transac_id'=>$orcoid,'status'=>'APPROVED'];
            
        $this->obj->storePaylogs($logArray);

        redirect(getUrl("events", "Events", "eventsList"));
    }    
}
