<?php
include_once "../model/events/EventsModel.php";
class EventsController
{

	private $obj;
	public $oops = "../view/404/404.php";
	#instancia class model para conexion a BD
	public function __construct()
	{

		$this->obj = new EventModel();
	}

	#Genera token de compra.
	public function generaToken($idE, $idU, $valor, $nombre)
	{

		return hash("sha256", $idE . $idU . $this->timestamp() . $valor . $nombre);
	}

	#Genera fecha y hora
	public function timestamp()
	{

		date_default_timezone_set('America/Bogota');
		$hoy = date("Y-m-d h:i:s A");
		return $hoy;
	}

	#Lista los eventos en la vista de "eventos"
	public function eventsList()
	{

		if (isset($_GET['catId'])) {

			$events = $this->obj->getEvents($_GET['catId']);
		} elseif (isset($_POST['event']) && isset($_POST['city'])) {

			$events = $this->obj->getEvents(false, $_POST['event'], $_POST['city']);
		} else {

			$events = $this->obj->getEvents();
		}

		$categories = $this->obj->getCategories();

		$cities = $this->obj->getCities();

		$dates = $this->obj->getDates();

		if ($events) {

			include_once "../view/events/events.php";
		} else {

			include_once $this->oops;
		}
	}

	#Muestra los detalles de un evento seleccionado
	public function eventDetails()
	{

		$event = $this->obj->getEventDetails($_GET['idE']);
		$localidades = $this->obj->getEventLoc($_GET['idE']);

		if ($event) {

			include_once "../view/events/eventDetails.php";
		} else {

			include_once $this->oops;
		}
	}

	#Muestra la vista del checkout del evento seleccionado
	public function showCheckout()
	{

		$idE = $_GET['idE'];
		if ($_SESSION) {

			# Consulta los atributos del evento master seleccionado
			if ($e = $this->obj->getEventCheckout($idE)) {

				# Consulta ordenes de compra del cliente en el mismo evento
				if ($goc = $this->obj->getOrdenCompraEvento($idE)) {

					# Si encuentra ordenes de compra pendientes valida la localidad pendiente a mostrar
					$_SESSION['message'] = 1;
					$_SESSION['message_icon'] = "warning";
					$_SESSION['message_text'] = "¡Atenci&oacute;n! Ya existe una orden de compra pendiente para este evento.";

					// calcular Cover service de orden compra vigente///
					$valorCS = $goc['locavabo'] * $goc['locapoco'] / 100;
					$ivaCS = $valorCS * $e['cavaaux1'] / 100;
					// $valorTotalCS = ceil(($valorCS + $ivaCS) / 100) * 100;
					$valorTotalCS = $valorCS + $ivaCS;
					$valorTotalCS = ceil((($valorCS + $ivaCS) * $goc['orcocabo']) / 100) * 100; //JFMI 04 FEB 2023
					$occantidad = $goc['orcocabo'];
					//$valorAPagar = ceil((($goc['locavabo'] + $valorTotalCS) * $goc['orcocabo']) / 100) * 100;
					$valorDesc = $goc['locavabo'] - ($goc['locavabo'] + $valorTotalCS); ////JFMI 04 FEB 2023
					$valorAPagar = $goc['orcovalo'] * $goc['orcocabo']; //JFMI 04 FEB 2023
					//$valorAPagar = $ivaCS;
					$valorDesc = $goc['orcovalo'] - ($goc['locavabo'] + $valorTotalCS);
					# Si no encuentra valida y muestra las localidades disponibles
				} else {

					# Consulta las localidades creadas para el evento master
					$locations = $this->obj->getEventLoc($idE);
				}

				include_once "../view/events/eventCheckout.php";
			}
		} else {

			redirect(getUrl("access", "Access", "showLogin", array('idE' => $idE), "access"));
		}
	}

	#Consulta disponibilidad de tickets, reserva y devuelve respuesta
	public function eventTicketReserve()
	{
		//print_r($_POST);
		$eLoc = $this->obj->getLocData($_POST['locId'], $_POST['idE']);
		//print_r($eLoc);

		if ($eLoc['evenesta'] != 19) // 19 = Disponible // JFMI 04 FEB 2023
		{
			$_SESSION['message'] = 1;
			$_SESSION['message_icon'] = "warning";
			$_SESSION['message_text'] = "!Oops! Este evento ya no se encuentra disponible";
			redirect(getUrl("home", "Home", "home"));
		}
		if ($tikets = $this->obj->getTicketsVendidos($_POST['locId'])) // JFMI 24 jun 2022
		{
			//print_r($tikets);

			//$bolDisp = ($localidad[0]["locacabo"] * $localidad[0]["locaboeq"]) - $maxTickestBlockchain;
			$bolDisp = ($eLoc['locacabo'] * $eLoc['locaboeq']) - $tikets["max"];
			$bolDisp = $bolDisp / $eLoc['locaboeq'];
		}
		if ($getOrden = $this->obj->getOrdenCompraEvento($_POST['idE'])) {
			//print_r("Passs 100");

			$_SESSION['message'] = 1;
			$_SESSION['message_icon'] = "warning";
			$_SESSION['message_text'] = "!Oops! Parece que ya tienes una orden de compra pendiente";
			redirect(getUrl("shoppingCart", "ShoppingCart", "showShoppingCart"));
		} else {
			//print_r("Passs 101");

			# Consulta los campos de la localidad de dicho evento
			//if($eLoc = $this->obj->getLocData($_POST['locId'], $_POST['idE'])) {
			if ($eLoc) {	// JFMI 24 jun 2022
				//print_r($eLoc);
				//print_r("CAntidad -->" . $_POST['qtybutton'] . "Disponibles :" . $bolDisp);
				//print_r("jodido 7:" . $eLoc['evencave'] . "--" . $_POST['qtybutton']);
				# Consulta que la cant permitida por compra no supere la cant solicitada
				if ($eLoc['evencave'] > 0 && $_POST['qtybutton'] > $eLoc['evencave']) {  // JFMI 04 Feb 2023

					print_r("PAse 1");
					//exit();
					$_SESSION['message'] = 1;
					$_SESSION['message_icon'] = "danger";
					$_SESSION['message_text'] = "!Oops! Parece que intentas comprar mas de los boletos permitidos ;)";
					redirect(getUrl("home", "Home", "home"));
				} else {
					if ($_POST['qtybutton'] > $bolDisp) { // JFMI 24 jun 2022	 / JFMI 04 FEB 2023
						$_SESSION['message'] = 1;
						$_SESSION['message_icon'] = "danger";
						$_SESSION['message_text'] = "!Oops! Parece que intentaste hacer algo indebido ;)";
						redirect(getUrl("home", "Home", "home"));
					} else {
						# Obtengo el total de boletos disponibles y comparo con la cantidad solicitada

						//$bolDisp = $eLoc['locacabo'] - $eLoc['locabove'];
						//print_r($bolDisp);
						/**/
						//if ($eLoc['locaboeq'] > 1) // JFMI 24 jun 2022
						//{
						/*
						if($tikets =$this->obj->getTicketsVendidos($_POST['locId'])) // JFMI 24 jun 2022
						{   //print_r($tikets);
							//$bolDisp = ($localidad[0]["locacabo"] * $localidad[0]["locaboeq"]) - $maxTickestBlockchain;
							$bolDisp = ($eLoc['locacabo'] * $eLoc['locaboeq']) - $tikets["max"];
							$bolDisp = $bolDisp / $eLoc['locaboeq'];
						}  
						*/
						//}
						//print_r($bolDisp);
						//die("EStamos fuera de servicio para reserva boletos :(, reintente mas tarde");

						if ($bolDisp >= $_POST['qtybutton']) {
							//JFMI 04 Feb 2023
							/**** Caclular el valor bruto de la compa  */
							$valorBruto = $eLoc['locavabo'];
							/********** **************/
							# Si el evento tiene habilitada la opcion de cupon y recibe un valor por POST
							if (isset($_POST['codProm']) && $eLoc['evencupo'] == 1) {

								# Consulta la veracidad del cupon
								if ($getC = $this->obj->getEventCoupon($eLoc['locaid'], $_POST['codProm'])) {

									$discountVal = $getC['cupodesc'];
									$couponId = $getC['cupoid'];
								} else {

									$_SESSION['message'] = 1;
									$_SESSION['message_icon'] = "warning";
									$_SESSION['message_text'] = "!Oops! C&oacute;digo promocional incorrecto, intenta de nuevo.";
									redirect(getUrl("events", "Events", "showCheckout", array("idE" => $_POST["idE"])));
								}
							} else {

								# Si no existe el valor por defecto es 0
								$couponId = 0;
							}

							if ($couponId == null) // JFMI 24 jun 2022 18:53pm
								$couponId = 0;

							# verifica si tiene cupon de descuento por valor
							if ($getC['cupotipo'] == 62) {

								$valorDes = $eLoc['locavabo'] - $discountVal;
								$valorDes = $discountVal; //JFMI 04 FEB 2023

								# verifica si tiene cupon de descuento por porcentaje
							} elseif ($getC['cupotipo'] == 61) {

								$valorDes = $eLoc['locavabo'] - ($eLoc['locavabo'] * $discountVal / 100);
								$valorDes = $valorBruto  * ($discountVal / 100); //JFMI 04 FEB 2023
								# Si no tiene cupon de descuento
							} else {

								$valorDes = $eLoc['locavabo'];
								$valorDes = 0; //JFMI 04 FEB 2023
							}

							// calcular Cover service y valor total a pagar///
							$valorCS = $valorDes * $eLoc['locapoco'] / 100;
							$valorCS = $valorBruto * $eLoc['locapoco'] / 100; //JFMI 04 FEB 2023


							$ivaCS = $valorCS * $eLoc['cavaaux1'] / 100;
							// $valorTotalCS = ceil(($valorCS + $ivaCS) / 100) * 100;
							$valorTotalCS = ceil($valorCS + $ivaCS);
							$valorAPagar = ceil((($valorDes + $valorTotalCS) * $_POST["qtybutton"]) / 100) * 100;
							$valorAPagar = ($valorBruto + $valorTotalCS - $valorDes) * $_POST["qtybutton"]; //JFMI 04 FEB 2023

							if ($valorAPagar % 100 != 0)
								$valorAPagar = (floor($valorAPagar / 100) * 100) + 100;



							# arreglo de datos que envia a función para el manejo de reserva
							$arrayData = [
								"action" => "reservarboletos",    // Palabra reservada
								"localidadid" => $eLoc['locaid'], // Localidad para la cual se reserva
								"cantidad" => $_POST['qtybutton'],   // Cantidad de boeltos a comprar
								"usuarioid" => $_SESSION['id'],  // Id del usuario que reserva
								"valor" => $valorAPagar,  // Valor Neto del boleto
								"eventipo" => $eLoc['eventipo'], // tipo de evento: gratis, pago, etc.
								"cupon" => $couponId,    // Identificador del Cupon en su defecto 0()
								"source" => "web"
							];

							#incluyo el archivo con la clase WebApi para consumir el servicio de API local
							include_once "../controller/webApi/WebApiController.php";

							$webApi = new webApiController();
							$logFile = fopen("apilog.txt", 'a') or die("Error creando archivo");
							fwrite($logFile, "\n" . date("d/m/Y H:i:s") . json_encode($arrayData)) or die("Error escribiendo en el archivo");
							fclose($logFile);

							$res = $webApi->boletoWebApiController($arrayData);
							$logFile = fopen("apilog.txt", 'a') or die("Error creando archivo");
							fwrite($logFile, "\n" . date("d/m/Y H:i:s") . "--> Response -->" . json_encode($res)) or die("Error escribiendo en el archivo");
							fclose($logFile);

							# Recibo la respuesta que retorna y defino el siguiente paso
							if ($res['status'] == 1 && $res['response'] == 1) {

								$_SESSION['message'] = 1;
								$_SESSION['message_icon'] = "success";
								$_SESSION['message_text'] = "¡Los boletos han sido reservados!";
								if ($eLoc['eventipo'] == 72) // Es gratuito // JFMI 24 jun 2022 18:53pm
								{
									$_SESSION['message_text'] = "¡Los boletos han sido transferidos a tu wallet!";
									redirect(getUrl("events", "Events", "eventsList"));
									//redirect(getUrl("shoppingCart", "ShoppingCart", "getFreepayApproved", array("orcotoke"=>$res['data']['orcotoke'])));
								} else
									redirect(getUrl("shoppingCart", "ShoppingCart", "showShoppingCart"));
							} elseif ($res['response'] == 0) {


								$_SESSION['message'] = 1;
								$_SESSION['message_icon'] = "error";
								$_SESSION['message_text'] = "¡Error al reservar boletos! Intentalo nuevamente Response: " . $res['status'] . " / message: " . $res['data'];

								redirect(getUrl("events", "Events", "showCheckout", array("idE" => $_POST['idE'])));
							} else {


								$_SESSION['message'] = 1;
								$_SESSION['message_icon'] = "error";
								$_SESSION['message_text'] = "¡Lo sentimos! Hemos tenido un error al realizar tu reserva. <br> Status: " . $res['status'] . " / message: " . $res['message'] . "";

								redirect(getUrl("events", "Events", "showCheckout", array("idE" => $_POST['idE'])));
							}
						} else {


							$_SESSION['message'] = 1;
							$_SESSION['message_icon'] = "warning";
							$_SESSION['message_text'] = "!Lo sentimos, la cantidad de boletos elegida excede la disponibilidad!";

							redirect(getUrl("events", "Events", "showCheckout", array("idE" => $_POST["idE"])));
						}
					} //ok
				} //else
			} //$eLoc
		}
	} //Fin Metodo

	# Funcion consumida para la validacion de tickets (cantidad en orden compra y disponibilidad) AJAX
	public function checkEventTicket()
	{

		$loc = $_POST['loc'];
		$qty = $_POST['qty'];

		# Si existe una orden de compra previamente para el mismo evento
		if (isset($_POST['ocid'])) {

			if ($getQty = $this->obj->ordenCompraAjax($_POST['ocid'], $loc)) {

				$setQty = $getQty['orcocabo'] + $qty;
				$locDispo = $getQty['locacabo'] - $getQty['locabove'];

				if ($tikets = $this->obj->getTicketsVendidos($loc)) // JFMI 24 jun 2022
				{
					//$bolDisp = ($localidad[0]["locacabo"] * $localidad[0]["locaboeq"]) - $maxTickestBlockchain;
					$locDispo = ($getQty['locacabo'] * $getQty['locaboeq']) - $tikets["max"];
					$locDispo = $locDispo / $getQty['locaboeq'];
				}
				//print_r($locDispo);
				//if($locDispo['evencave'] > 0) {
				if ($locDispo > 0) {

					$ticketsqty = $getQty['evencave'];
				} else {

					$ticketsqty = FALSE;
				}

				# Si la cantidad en la ordencompra es igual o mayor a la establecida
				# Si la cantidad total es mayor a a la establecida
				# Si la cantidad total supera los boletos disponibles
				if ($ticketsqty) {

					if ($getQty['orcocabo'] > $ticketsqty || ($setQty > $ticketsqty) || ($setQty > $locDispo)) {

						echo '{"result": "forbidden"}';
					} else {

						echo '{"result": "passed"}';
					}
				} else {

					echo '{"result": "passed"}';
				}
			}
		} else {

			# Si no existe orden compra
			if ($locDispo = $this->obj->getTicketAjax($loc)) {

				if ($locDispo['evencave'] > 0) {

					$ticketsqty = $locDispo['evencave'];
				} else {

					$ticketsqty = FALSE;
				}
				# Verifica que la cantidad disponible sea mayor a la solicitada y no supere 5
				$locdis = $locDispo['locacabo'] - $locDispo['locabove'];

				if ($tikets = $this->obj->getTicketsVendidos($loc)) // JFMI 24 jun 2022
				{
					//$bolDisp = ($localidad[0]["locacabo"] * $localidad[0]["locaboeq"]) - $maxTickestBlockchain;
					$locdis = ($locDispo['locacabo'] * $locDispo['locaboeq']) - $tikets["max"];
					$locdis = $locDispo / $locDispo['locaboeq'];
				}

				if ($ticketsqty) {

					if ($locdis < $qty || $qty > $ticketsqty) {

						echo '{"result": "forbidden"}';
					} else {

						echo '{"result": "passed"}';
					}
				} else {

					echo '{"result": "passed"}';
				}
			}
		}
	}

	# Funcion que muestra datos del evento AJAX
	public function getEventData()
	{

		$locaid = $_GET['locaid'];

		if ($getEventData = $this->obj->getEventDataAjax($locaid)) {

			echo json_encode($getEventData);
		}
	}
}
